﻿<%@ Page Language="c#" CodePage="1200" %>

<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Kasa" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Pełny raport kasowy</title>

		<script runat="server">

			class Element : IComparable {
				readonly string nazwa;
				decimal wpłaty;
				decimal wypłaty;
				public Element(Zaplata z) {
					this.nazwa = z.SposobZaplaty.Nazwa;
				}
				public void Add(Zaplata z) {
					wpłaty += z.Wpłata.Value;
					wypłaty += z.Wypłata.Value;
				}
				public int CompareTo(object v) {
					return string.Compare(Nazwa, ((Element)v).Nazwa, true);
				}
				public string Nazwa {
					get { return nazwa; }
				}
				public decimal Wpłata {
					get { return wpłaty; }
				}
				public decimal Wypłata {
					get { return wypłaty; }
				}
				public decimal Saldo {
					get { return wpłaty - wypłaty; }
				}
			}

			class Element2 {
				readonly string nazwa;
				object wpłaty;
				object wypłaty;
				static string marker = "--------------";
				public Element2(string nazwa, object wpłaty, object wypłaty) {
					this.nazwa = nazwa;
					this.wpłaty = wpłaty;
					this.wypłaty = wypłaty;
				}
				public string Nazwa {
					get { return nazwa; }
				}
				public object Wpłata {
					get { return wpłaty != null ? wpłaty : marker; }
				}
				public object Wypłata {
					get { return wypłaty != null ? wypłaty : marker; }
				}
			}
	
			Hashtable elements = new Hashtable();
			decimal sumWpł = 0;
			decimal sumWypł = 0;

			void Grid1_BeforeRow(Object sender, RowEventArgs args) {
				Zaplata z = (Zaplata)args.Row;
				if (z.NumeryDokumentow == ""||z.Opis.Contains(z.NumeryDokumentow))
					opis.EditValue = z.Opis;
				else
					opis.EditValue = z.Opis + ", " + z.NumeryDokumentow;

				Element elem = (Element)elements[z.SposobZaplaty];
				if (elem == null) {
					elem = new Element(z);
					elements[z.SposobZaplaty] = elem;
				}
				elem.Add(z);

				sumWpł += z.Wpłata.Value;
				sumWypł += z.Wypłata.Value;
			}

			void Grid1_AfterRender(Object sender, EventArgs args) {

				ArrayList arr = new ArrayList(elements.Values);
				arr.Sort();
				Grid2.DataSource = arr;

				Row[] rows = (Row[])dc[typeof(Row[])];
				decimal sp = 0m;
				decimal sk = 0m;
				foreach (RaportESP raport in rows) {
					sp += raport.SaldoPoczatkowe.Value;
					sk += raport.SaldoKoncowe.Value;
				}
				
				Element2[] els = new Element2[3];
				els[0] = new Element2("Obroty", sumWpł, sumWypł);
				els[1] = new Element2("Stan poprzedni", GT(sp), LT(sp));
				els[2] = new Element2("Stan obecny", LT(sk), GT(sk));

				Grid3.DataSource = els;
			}

			object GT(decimal value) {
				if (value > 0)
					return value;
				return null;
			}

			object LT(decimal value) {
				if (value < 0)
					return -value;
				return null;
			}

			protected void dc_ContextLoad(object sender, EventArgs e) {
				Row[] rows = (Row[])dc[typeof(Row[])];
				ArrayList lista = new ArrayList();
				RaportESP first = null;
				string nagłowek = "Wspólnt raport kasowy";
				EwidencjaSP ewidencja = null;
				string numery = "";
				foreach (RaportESP raport in rows) {
					if (numery != "")
						numery += ", ";
					numery += raport.Numer.NumerPelny;
					if (first == null) {
						first = raport;
						ewidencja = raport.Kasa;
					}
					else {
						if (ewidencja != null && ewidencja != raport.Kasa)
							ewidencja = null;
						if (first.Kasa.Typ != raport.Kasa.Typ)
							throw new RowException(raport, "Wspólny raport kasowy może być drukowany tylko dla raportów tego samego typu");
						else if (first.Okres != raport.Okres)
							throw new RowException(raport, "Wspólny raport kasowy może być drukowany tylko dla raportów za ten sam okres");
						else if (first.Kasa.Waluta != raport.Kasa.Waluta)
							throw new RowException(raport, "Wspólny raport kasowy może być drukowany tylko dla raportów z ewidencji w tej samej walucie");
					}

					foreach (Zaplata z in raport.Zaplaty)
						lista.Add(z);
				}
				
				if (first==null || first.Kasa.Typ == TypEwidencjiSP.Kasa)
					ReportHeader1["NAGŁÓWEK"] = "RAPORT KASOWY";
				else {
					ReportHeader1["NAGŁÓWEK"] = "WYCIĄG BANKOWY";
					opis.Width += numer.Width;
					numer.Visible = false;
				}

				if (ewidencja != null)
					ReportHeader1["EWIDENCJA"] = "|</strong>Ewidencja: <strong>" + ewidencja + "|";
				else
					ReportHeader1["EWIDENCJA"] = "";
				if (first != null) {
					ReportHeader1["WALUTA"] = first.Kasa.Waluta.Symbol;
					ReportHeader1["OKRES"] = first.Okres.ToString();
				}
				ReportHeader1["RAPORTY"] = numery;

				//lista.Sort(...)
				Grid1.DataSource = lista;
			}
			
		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	</HEAD>

	<body>
		<form id="PełnyRaportKasowy" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:datacontext>
			<cc1:ReportHeader id="ReportHeader1" title="WSPÓLNY %NAGŁÓWEK%|%EWIDENCJA%</strong>Waluta: <strong>%WALUTA%|</strong>Okres:<strong> %OKRES%|</strong>Raporty: <strong>%RAPORTY%" runat="server"></cc1:ReportHeader>

			<ea:grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" RowTypeName="Soneta.Kasa.Zaplata, Soneta.Kasa, Version=1.0.1118.12462, Culture=neutral, PublicKeyToken=null" OnAfterRender="Grid1_AfterRender">
				<Columns>
					<ea:GridColumn EncodeHTML="true" Width="4" Align="Right" DataMember="Lp" Caption="LP." ID="lp" runat="server"></ea:GridColumn>
					<ea:GridColumn EncodeHTML="true" Width="10" DataMember="DataDokumentu" Caption="Data" ID="data" runat="server"></ea:GridColumn>
					<ea:GridColumn EncodeHTML="true" Width="0" DataMember="NumerDokumentu" Caption="Numer" ID="numer" NoWrap="True" runat="server"></ea:GridColumn>
					<ea:GridColumn EncodeHTML="true" Width="12" DataMember="Podmiot.Kod" Caption="Podmiot" ID="podmiot" NoWrap="True" runat="server"></ea:GridColumn>
					<ea:GridColumn EncodeHTML="true" Width="32" Caption="Opis" ID="opis" NoWrap="True" runat="server"></ea:GridColumn>
					<ea:GridColumn EncodeHTML="true" DataMember="SposobZaplaty" Caption="Forma" runat="server"></ea:GridColumn>
					<ea:GridColumn EncodeHTML="true" Width="12" Align="Right" DataMember="Wpłata" Total="Sum" Caption="Wpłata" HideZero="True" Format="{0:n}" ID="Wpłata" runat="server"></ea:GridColumn>
					<ea:GridColumn EncodeHTML="true" Width="12" Align="Right" DataMember="Wypłata" Total="Sum" Caption="Wypłata" HideZero="True" Format="{0:n}" ID="wypłata" runat="server"></ea:GridColumn>
				</Columns>
			</ea:grid>
			<p />

			<section>
				<table id="Table3" cellspacing="0" width="100%">
					<tbody>
						<tr>
							<td valign="top">
								<ea:grid id="Grid2" runat="server" WithSections="false" >
									<Columns>
										<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." ID="lp2"></ea:GridColumn>
										<ea:GridColumn Width="13" DataMember="Nazwa" Total="Info" Caption="Sposób zapłaty" ID="płatność2"></ea:GridColumn>
										<ea:GridColumn Width="14" Align="Right" DataMember="Wpłata" Total="Sum" Caption="Wpłata" Format="{0:n}" ID="wpłata2"></ea:GridColumn>
										<ea:GridColumn Width="14" Align="Right" DataMember="Wypłata" Total="Sum" Caption="Wypłata" Format="{0:n}" ID="wypłata2"></ea:GridColumn>
										<ea:GridColumn Width="14" Align="Right" DataMember="Saldo" Total="Sum" Caption="R&#243;żnica" Format="{0:n}" ID="saldo2"></ea:GridColumn>
									</Columns>
								</ea:grid>
							</td>
							<td style="width:1mm">&nbsp;</td>
							<td valign="top" align="right">
								<ea:grid id="Grid3" runat="server" WithSections="false" >
									<Columns>
										<ea:GridColumn Width="12" DataMember="Nazwa" Total="Info" ID="pozycja3"></ea:GridColumn>
										<ea:GridColumn Width="14" Align="Right" DataMember="Wpłata" Total="Sum" Caption="Wpłata" Format="{0:n}" ID="wpłata3"></ea:GridColumn>
										<ea:GridColumn Width="14" Align="Right" DataMember="Wypłata" Total="Sum" Caption="Wypłata" Format="{0:n}" ID="wypłata3"></ea:GridColumn>
									</Columns>
								</ea:grid>
							</td>
						</tr>
					</tbody>
				</table>
			</section>

			<cc1:ReportFooter id="ReportFooter1" runat="server">
				<Subtitles>
					<cc1:FooterSubtitle SubtitleType="Operator"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Sporządził" SubtitleType="Podpis"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Sprawdził" SubtitleType="Podpis"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Zatwierdził" SubtitleType="Data"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:ReportFooter>
		</form>
	</body>
</HTML>
